function y = testsignal
% Generates ns log-sine sweeps

  global Ls
  global fs
  global f1
  global f2
  global ns
  global ts
  global tf
  global tp
  global td
  global tp1
  global tp2
  
  a=10^(Ls/20);          % amplitude of test signal
  dt = 1 /fs;            % sample interval
  t=0:dt:ts;
  
  ys=a*sin(2*pi*f1*ts/log(f2/f1)*(exp(log(f2/f1)*t/ts) -1));
  
  t=0:dt:tf-dt;
  ys(1:tf*fs) = ys(1:tf*fs) .* (t/tf -1/2/pi*sin(2*pi*t/tf));
  
  ys(end+1-tf*fs:end) = ys(end+1-tf*fs:end) .* ...
                (1-t/tf +1/2/pi*sin(2*pi*t/tf ));            
                
  yp=zeros(1,(tp+td)*fs-1);
  y1=zeros(1,tp1*fs);
  y2=zeros(1,tp2*fs);
  
  ysp=[ys yp];
  y=ysp;
  for i = 1:ns-1
    y=[y ysp];
  end
  
  y=[y1 y y2];  
  y=[y;y]; 
  
end
